import 'package:flutter/foundation.dart';
import 'package:viser_remit/data/model/kyc/kyc_response_model.dart';

import '../auth/login/login_response_model.dart';

class BusinessProfileFieldModel {
  BusinessProfileFieldModel({
      String? remark, 
      String? status, 
      Message? message, 
      Data? data,}){
    _remark = remark;
    _status = status;
    _message = message;
    _data = data;
}

  BusinessProfileFieldModel.fromJson(dynamic json) {
    _remark = json['remark'];
    _status = json['status'].toString();
    _message = json['message'] != null ? Message.fromJson(json['message']) : null;
    _data = json['data'] != null ? Data.fromJson(json['data']) : null;
  }
  String? _remark;
  String? _status;
  Message? _message;
  Data? _data;

  String? get remark => _remark;
  String? get status => _status;
  Message? get message => _message;
  Data? get data => _data;


}

class Data {
  Data({
      Form? form,}){
    _form = form;
}

  Data.fromJson(dynamic json) {
    _form = json['form'] != null ? Form.fromJson(json['form']) : null;
  }
  Form? _form;

  Form? get form => _form;


}


class Form {
  List<KycFormModel>? _list;

  Form.fromJson(dynamic json) {
    var map = Map.from(json).map((key, value) => MapEntry(key, value));
    try {
      List<KycFormModel>? list = map.entries.map((e) {
        // Convert 'extensions' to a String if it's a List
        var extensions = e.value['extensions'];
        if (extensions is List) {
          extensions = extensions.join(','); // Join the list to a comma-separated string
        }

        return KycFormModel(
          e.value['name'],
          e.value['label'],
          e.value['is_required'],
          e.value['instruction'],
          extensions, // Correct assignment
          (e.value['options'] as List).map((e) => e as String).toList(),
          e.value['type'],
          '', // Or assign a relevant initial value
        );
      }).toList();

      if (list.isNotEmpty) {
        list.removeWhere((element) => element.toString().isEmpty);
        _list?.addAll(list);
      }
    } catch (e) {
      if (kDebugMode) {
        print(e.toString());
      }
    }
  }
}


